/*
 Navicat Premium Data Transfer

 Source Server         : localhost
 Source Server Type    : MySQL
 Source Server Version : 50540
 Source Host           : localhost:3306
 Source Schema         : ljcms_20171023

 Target Server Type    : MySQL
 Target Server Version : 50540
 File Encoding         : 65001

 Date: 04/01/2019 10:03:07
*/

SET NAMES utf8mb4;
SET FOREIGN_KEY_CHECKS = 0;


-- ----------------------------
-- Table structure for oa_contact
-- ----------------------------
DROP TABLE IF EXISTS `oa_contact`;
CREATE TABLE `oa_contact`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '姓名',
  `letter` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '拼音',
  `company` varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '公司',
  `dept` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '部门',
  `position` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '职位',
  `email` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '邮件',
  `office_tel` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '办公电话',
  `mobile_tel` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '移动电话',
  `website` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '网站',
  `im` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '即时通讯',
  `address` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '地址',
  `user_id` int(11) NOT NULL DEFAULT 0 COMMENT '用户ID',
  `remark` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '备注',
  `is_del` tinyint(3) NOT NULL DEFAULT 0 COMMENT '删除标记',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 7 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = 'think_user_info' ROW_FORMAT = Compact;


-- ----------------------------
-- Table structure for oa_customer
-- ----------------------------
DROP TABLE IF EXISTS `oa_customer`;
CREATE TABLE `oa_customer`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '名称',
  `letter` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '拼音',
  `biz_license` varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '营业许可',
  `short` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '简称',
  `contact` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '联系人姓名',
  `email` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '邮件地址',
  `office_tel` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '办公电话',
  `mobile_tel` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '移动电话',
  `fax` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '传真',
  `salesman` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '业务员',
  `im` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '即时通讯',
  `address` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '地址',
  `user_id` int(11) NOT NULL DEFAULT 0 COMMENT '用户ID',
  `remark` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '备注',
  `is_del` tinyint(3) NOT NULL DEFAULT 0 COMMENT '删除标记',
  `payment` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 4 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Compact;


-- ----------------------------
-- Table structure for oa_dept
-- ----------------------------
DROP TABLE IF EXISTS `oa_dept`;
CREATE TABLE `oa_dept`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pid` int(11) NOT NULL DEFAULT 0 COMMENT '父级ID',
  `dept_no` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '部门编号',
  `dept_grade_id` int(11) NOT NULL DEFAULT 0 COMMENT '部门等级ID',
  `name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '名称',
  `short` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '简称',
  `sort` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '排序',
  `remark` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '备注',
  `is_del` tinyint(3) NOT NULL DEFAULT 0 COMMENT '删除标记',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 28 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Compact;

-- ----------------------------
-- Records of oa_dept
-- ----------------------------
INSERT INTO `oa_dept` VALUES (1, 0, 'A2', 18, '良精企业', '良精', '', '', 0);
INSERT INTO `oa_dept` VALUES (2, 1, 'YYB', 18, '运营部', '运营', '5', '', 0);
INSERT INTO `oa_dept` VALUES (5, 1, 'ZJB', 18, '总经理1', '总经', '1', '', 0);
INSERT INTO `oa_dept` VALUES (6, 1, 'GLB', 18, '管理部', '管理', '2', '', 0);
INSERT INTO `oa_dept` VALUES (7, 1, 'XSB', 18, '销售部', '销售', '3', '', 0);
INSERT INTO `oa_dept` VALUES (8, 1, 'CWB', 18, '财务部', '财务', '2', '', 0);
INSERT INTO `oa_dept` VALUES (25, 8, 'KJK', 16, '会计科', '会计', '', '', 0);
INSERT INTO `oa_dept` VALUES (26, 8, 'JRK', 16, '金融科', '金融', '', '', 0);
INSERT INTO `oa_dept` VALUES (27, 1, '', 18, '技术部', '技术', '9', '', 0);

-- ----------------------------
-- Table structure for oa_dept_grade
-- ----------------------------
DROP TABLE IF EXISTS `oa_dept_grade`;
CREATE TABLE `oa_dept_grade`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `grade_no` varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '部门级别编码',
  `name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '名称',
  `sort` varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '排序',
  `is_del` tinyint(3) NOT NULL DEFAULT 0 COMMENT '删除标记',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 21 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Compact;

-- ----------------------------
-- Records of oa_dept_grade
-- ----------------------------
INSERT INTO `oa_dept_grade` VALUES (16, 'DG1', '科', '1', 0);
INSERT INTO `oa_dept_grade` VALUES (18, 'DG2', '部', '2', 0);
-- ----------------------------
-- Table structure for oa_file
-- ----------------------------
DROP TABLE IF EXISTS `oa_file`;
CREATE TABLE `oa_file`  (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '文件ID',
  `name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '原始文件名',
  `savename` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '保存名称',
  `savepath` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '文件保存路径',
  `ext` char(5) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '文件后缀',
  `mime` char(40) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '文件mime类型',
  `size` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '文件大小',
  `md5` char(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '文件md5',
  `sha1` char(40) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '文件 sha1编码',
  `location` tinyint(3) UNSIGNED NOT NULL DEFAULT 0 COMMENT '文件保存位置',
  `url` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '远程地址',
  `create_time` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '上传时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 79 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '文件表' ROW_FORMAT = Compact;


-- ----------------------------
-- Table structure for oa_finance
-- ----------------------------
DROP TABLE IF EXISTS `oa_finance`;
CREATE TABLE `oa_finance`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `doc_no` varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '单据编号',
  `remark` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `input_date` date NULL DEFAULT NULL COMMENT '录入日期',
  `account_id` int(11) NULL DEFAULT NULL COMMENT '帐号ID',
  `account_name` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '帐号名',
  `income` float(11, 2) NULL DEFAULT NULL COMMENT '收入',
  `payment` float(11, 2) NULL DEFAULT NULL COMMENT '支出',
  `amount` float(11, 2) NULL DEFAULT NULL COMMENT '合计',
  `type` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '类型',
  `partner` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '来往处',
  `actor_name` varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '经办人',
  `user_id` int(11) NULL DEFAULT NULL COMMENT '登陆人',
  `user_name` varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '登录名',
  `create_time` int(11) NULL DEFAULT NULL COMMENT '创建日期',
  `update_time` int(11) NULL DEFAULT NULL COMMENT '更新日期',
  `add_file` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '附件',
  `doc_type` tinyint(3) NULL DEFAULT NULL COMMENT '类型',
  `is_del` tinyint(3) NULL DEFAULT 0 COMMENT '删除标记',
  `related_account_id` int(11) NULL DEFAULT NULL COMMENT '相关帐号ID',
  `related_account_name` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '相关帐号名称',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 7 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Compact;


-- ----------------------------
-- Table structure for oa_finance_account
-- ----------------------------
DROP TABLE IF EXISTS `oa_finance_account`;
CREATE TABLE `oa_finance_account`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '帐号名称',
  `bank` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '银行',
  `no` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '银行帐号',
  `init` int(11) NULL DEFAULT NULL COMMENT '初始帐号',
  `balance` int(11) NULL DEFAULT NULL COMMENT '余额',
  `remark` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '备注',
  `is_del` tinyint(3) NULL DEFAULT 0 COMMENT '删除标记',
  `create_time` int(11) NULL DEFAULT NULL COMMENT '创建时间',
  `update_time` int(11) NULL DEFAULT NULL COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 4 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Compact;


-- ----------------------------
-- Table structure for oa_leave
-- ----------------------------
DROP TABLE IF EXISTS `oa_leave`;
CREATE TABLE `oa_leave`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `time` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `end_time` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `user_name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `user_id` int(11) NULL DEFAULT NULL,
  `type` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `hour` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `content` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `status` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '0',
  `auditor` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `update_time` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `shen_msg` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `dept_id` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 5 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;


-- ----------------------------
-- Table structure for oa_message
-- ----------------------------
DROP TABLE IF EXISTS `oa_message`;
CREATE TABLE `oa_message`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `content` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '内容',
  `add_file` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '附件',
  `sender_id` int(11) NULL DEFAULT NULL COMMENT '发送人',
  `sender_name` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '发送人名称',
  `receiver_id` int(11) NULL DEFAULT NULL COMMENT '接收人',
  `receiver_name` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '接收人名称',
  `create_time` int(11) NULL DEFAULT NULL COMMENT '创建时间',
  `owner_id` int(11) NULL DEFAULT NULL COMMENT '拥有者',
  `is_del` tinyint(3) NULL DEFAULT 0 COMMENT '删除标记',
  `is_read` tinyint(3) NULL DEFAULT 0 COMMENT '是否已读',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 44 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Compact;


-- ----------------------------
-- Table structure for oa_node
-- ----------------------------
DROP TABLE IF EXISTS `oa_node`;
CREATE TABLE `oa_node`  (
  `id` smallint(6) UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '名称',
  `url` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT 'URL地址',
  `icon` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '图标',
  `sub_folder` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '子文件夹',
  `remark` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '备注',
  `sort` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '排序',
  `pid` smallint(5) UNSIGNED NOT NULL DEFAULT 0 COMMENT '父ID',
  `is_del` tinyint(3) NOT NULL DEFAULT 0 COMMENT '删除标记',
  `badge_function` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '统计函数',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `pid`(`pid`) USING BTREE,
  INDEX `status`(`is_del`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 248 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Compact;

-- ----------------------------
-- Records of oa_node
-- ----------------------------
INSERT INTO `oa_node` VALUES (84, '管理', '?c=System', 'fa fa-cogs', '', '', '999', 0, 0, '');
INSERT INTO `oa_node` VALUES (91, '日程', '?c=Schedule', 'fa fa-calendar bc-personal-schedule', '', '', '2', 198, 0, 'badge_count_schedule');
INSERT INTO `oa_node` VALUES (110, '公司信息管理', '', NULL, NULL, '', '1', 84, 0, NULL);
INSERT INTO `oa_node` VALUES (112, '权限管理', '', NULL, NULL, '', '3', 84, 0, NULL);
INSERT INTO `oa_node` VALUES (113, '系统设定', '', NULL, NULL, '', '4', 84, 0, NULL);
INSERT INTO `oa_node` VALUES (114, '系统参数设置', '?c=System&a=config', '', '', '', '2', 113, 0, '');
INSERT INTO `oa_node` VALUES (115, '组织图', '?c=Dept', '', '', '', '1', 110, 0, '');
INSERT INTO `oa_node` VALUES (116, '员工登记', '?c=User', '', '', '', '5', 110, 0, '');
INSERT INTO `oa_node` VALUES (118, '权限组管理', '?c=Role', '', '', '', '1', 112, 0, '');
INSERT INTO `oa_node` VALUES (119, '权限设置', '?c=Role&a=node', '', '', '', '2', 112, 0, '');
INSERT INTO `oa_node` VALUES (120, '权限分配', '?c=Role&a=user', '', '', '', '3', 112, 0, '');
INSERT INTO `oa_node` VALUES (121, '菜单管理', '?c=Node', '', '', '', '1', 113, 0, NULL);
INSERT INTO `oa_node` VALUES (123, '职位', '?c=Position', '', '', '', '2', 110, 0, '');
INSERT INTO `oa_node` VALUES (125, '联系人', '?c=Contact', '', '', '', '1', 198, 0, '');
INSERT INTO `oa_node` VALUES (152, '待办', '?c=Todo', 'fa fa-tasks bc-personal-todo', '', '', '9', 198, 0, 'badge_count_todo');
INSERT INTO `oa_node` VALUES (153, '部门级别', '?c=DeptGrade', '', '', '', '4', 110, 0, '');
INSERT INTO `oa_node` VALUES (156, '客户', '?c=Customer', '', '', '', '2', 157, 0, '');
INSERT INTO `oa_node` VALUES (157, '通讯录', '?c=Staff', 'fa fa-group', '', '', '7', 0, 0, 'badge_sum');
INSERT INTO `oa_node` VALUES (158, '供应商', '?c=Supplier', '', '', '', '3', 157, 0, '');
INSERT INTO `oa_node` VALUES (169, '职员', '?c=Staff', '', '', '', '', 157, 0, '');
INSERT INTO `oa_node` VALUES (190, '消息', '?c=Message', 'fa fa-inbox bc-message', '', '', '99', 198, 0, 'badge_count_message');
INSERT INTO `oa_node` VALUES (191, '用户设置', '', '', '', '', '', 198, 0, NULL);
INSERT INTO `oa_node` VALUES (192, '用户资料', '?c=User&a=info', '', '', '', '', 191, 0, '');
INSERT INTO `oa_node` VALUES (193, '修改密码', '?c=User&a=pwd', '', '', '', '', 191, 0, '');
INSERT INTO `oa_node` VALUES (198, '个人', '?c=User&a=info', 'fa fa-user bc-personal', '', '', '9', 0, 0, 'badge_sum');
INSERT INTO `oa_node` VALUES (214, '记账', '?c=Finance', 'fa fa-jpy', '', '', '3', 217, 0, '');
INSERT INTO `oa_node` VALUES (216, '日报', '?c=Work', 'fa fa-book', '', '', '1', 217, 0, '');
INSERT INTO `oa_node` VALUES (217, '工作', '?c=Work', 'fa fa-book', '', '', '6', 0, 0, 'badge_sum');
INSERT INTO `oa_node` VALUES (224, '任务', '?c=Task', 'fa fa-book', '', '', '2', 217, 0, 'badge_count_task');
INSERT INTO `oa_node` VALUES (237, '日程日视图', '?c=Schedule&a=day_view', '', NULL, '', '', 91, 1, '');
INSERT INTO `oa_node` VALUES (238, '公告管理', '?c=Notice', '', NULL, '', '0', 110, 0, '');
INSERT INTO `oa_node` VALUES (239, '考勤', '?c=Sign', 'fa fa-calendar', NULL, '', '5', 0, 0, 'badge_sum');
INSERT INTO `oa_node` VALUES (240, '我的考勤', '?c=Sign', '', NULL, NULL, '0', 239, 0, '');
INSERT INTO `oa_node` VALUES (241, '考勤规则', '?c=Sign&a=Sign_rule', '', NULL, '', '1', 239, 0, '');
INSERT INTO `oa_node` VALUES (243, '请假/加班', '?c=Sign&a=leave', '', NULL, '', '3', 239, 0, 'badge_count_leave');
INSERT INTO `oa_node` VALUES (244, '请假/加班统计', '?c=Sign&a=leave_count', '', NULL, '', '5', 239, 0, '');
INSERT INTO `oa_node` VALUES (245, '请假加班审核', '?c=Sign&a=leave_shen', '', NULL, '', '5', 239, 0, 'badge_count_leave_shen');
INSERT INTO `oa_node` VALUES (246, '考勤统计', '?c=Sign&a=sign_count', '', NULL, '', '2', 239, 0, '');
INSERT INTO `oa_node` VALUES (247, '日报审核', '?c=Work&a=work_shen', '', NULL, '', '4', 217, 0, 'badge_count_work');

-- ----------------------------
-- Table structure for oa_notice
-- ----------------------------
DROP TABLE IF EXISTS `oa_notice`;
CREATE TABLE `oa_notice`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `content` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `time` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `user_id` int(11) NULL DEFAULT NULL,
  `user_name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `title` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 3 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;


-- ----------------------------
-- Table structure for oa_position
-- ----------------------------
DROP TABLE IF EXISTS `oa_position`;
CREATE TABLE `oa_position`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `position_no` varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '编号',
  `name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '名称',
  `sort` varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '排序',
  `is_del` tinyint(3) NOT NULL DEFAULT 0 COMMENT '删除标记',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 7 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Compact;

-- ----------------------------
-- Records of oa_position
-- ----------------------------
INSERT INTO `oa_position` VALUES (1, '011', '主管', '5', 0);
INSERT INTO `oa_position` VALUES (2, '04', '经理', '4', 0);
INSERT INTO `oa_position` VALUES (3, '03', '总监', '3', 0);
INSERT INTO `oa_position` VALUES (4, '02', '副总', '2', 0);
INSERT INTO `oa_position` VALUES (6, '06', '助理', '6', 0);
INSERT INTO `oa_position` VALUES (5, '01', '总经理', '1', 0);
-- ----------------------------
-- Table structure for oa_role
-- ----------------------------
DROP TABLE IF EXISTS `oa_role`;
CREATE TABLE `oa_role`  (
  `id` smallint(6) UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `pid` smallint(6) NULL DEFAULT NULL,
  `remark` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `sort` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `create_time` int(11) UNSIGNED NOT NULL,
  `update_time` int(11) UNSIGNED NOT NULL,
  `is_del` tinyint(3) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `parentId`(`pid`) USING BTREE,
  INDEX `ename`(`sort`) USING BTREE,
  INDEX `status`(`is_del`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 10 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Compact;

-- ----------------------------
-- Records of oa_role
-- ----------------------------
INSERT INTO `oa_role` VALUES (1, '公司管理员', 0, '', '1', 1208784792, 1545121520, 0);
-- ----------------------------
-- Table structure for oa_role_node
-- ----------------------------
DROP TABLE IF EXISTS `oa_role_node`;
CREATE TABLE `oa_role_node`  (
  `role_id` int(11) NOT NULL,
  `node_id` int(11) NOT NULL,
  `admin` tinyint(1) NULL DEFAULT NULL,
  `read` tinyint(1) NULL DEFAULT NULL,
  `write` tinyint(1) NULL DEFAULT NULL
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Compact;

-- ----------------------------
-- Records of oa_role_node
-- ----------------------------
INSERT INTO `oa_role_node` VALUES (2, 136, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (2, 135, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (1, 94, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (1, 97, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (1, 98, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (1, 99, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (1, 69, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (1, 6, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (1, 2, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (1, 7, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (1, 131, 1, 1, 1);
INSERT INTO `oa_role_node` VALUES (1, 130, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (1, 133, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (1, 132, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (1, 135, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (1, 136, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (1, 117, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (1, 134, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (2, 103, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (2, 133, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (2, 130, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (7, 124, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (2, 134, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (2, 132, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (2, 103, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (2, 103, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (2, 109, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (1, 117, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (1, 117, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (1, 117, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (1, 117, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (1, 103, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (1, 109, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (1, 117, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (1, 117, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (1, 163, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (1, 170, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (1, 164, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (1, 155, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (1, 154, 1, 1, 1);
INSERT INTO `oa_role_node` VALUES (1, 111, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (1, 168, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (1, 162, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (1, 166, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (1, 161, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (1, 171, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (1, 165, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (1, 174, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (1, 172, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (1, 173, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (1, 160, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (1, 175, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (1, 176, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (1, 167, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (1, 128, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (2, 85, 1, 1, 1);
INSERT INTO `oa_role_node` VALUES (2, 100, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (2, 101, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (2, 106, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (2, 104, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (2, 105, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (2, 107, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (2, 177, 1, 1, 1);
INSERT INTO `oa_role_node` VALUES (2, 102, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (2, 143, 1, 1, 1);
INSERT INTO `oa_role_node` VALUES (2, 108, 1, 1, 1);
INSERT INTO `oa_role_node` VALUES (2, 124, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (2, 88, NULL, 1, 1);
INSERT INTO `oa_role_node` VALUES (2, 126, NULL, 1, 1);
INSERT INTO `oa_role_node` VALUES (2, 219, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (2, 220, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (2, 226, NULL, 1, 1);
INSERT INTO `oa_role_node` VALUES (2, 217, NULL, 1, 1);
INSERT INTO `oa_role_node` VALUES (2, 216, NULL, 1, 1);
INSERT INTO `oa_role_node` VALUES (2, 224, NULL, 1, 1);
INSERT INTO `oa_role_node` VALUES (2, 230, NULL, 1, 1);
INSERT INTO `oa_role_node` VALUES (2, 157, 1, 1, 1);
INSERT INTO `oa_role_node` VALUES (2, 169, 1, 1, 1);
INSERT INTO `oa_role_node` VALUES (2, 156, 1, 1, 1);
INSERT INTO `oa_role_node` VALUES (2, 158, 1, 1, 1);
INSERT INTO `oa_role_node` VALUES (2, 229, NULL, 1, 1);
INSERT INTO `oa_role_node` VALUES (2, 198, 1, 1, 1);
INSERT INTO `oa_role_node` VALUES (2, 191, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (2, 193, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (2, 192, 1, 1, 1);
INSERT INTO `oa_role_node` VALUES (2, 194, 1, 1, 1);
INSERT INTO `oa_role_node` VALUES (2, 125, 1, 1, 1);
INSERT INTO `oa_role_node` VALUES (2, 91, 1, 1, 1);
INSERT INTO `oa_role_node` VALUES (2, 152, 1, 1, 1);
INSERT INTO `oa_role_node` VALUES (2, 190, 1, 1, 1);
INSERT INTO `oa_role_node` VALUES (2, 87, 1, 1, 1);
INSERT INTO `oa_role_node` VALUES (2, 144, 1, 1, 1);
INSERT INTO `oa_role_node` VALUES (2, 149, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (2, 150, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (2, 147, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (2, 148, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (2, 185, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (2, 221, NULL, 1, NULL);
INSERT INTO `oa_role_node` VALUES (1, 247, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (1, 246, 1, 1, 1);
INSERT INTO `oa_role_node` VALUES (1, 235, 1, 1, 1);
INSERT INTO `oa_role_node` VALUES (1, 230, 1, 1, 1);
INSERT INTO `oa_role_node` VALUES (1, 231, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (1, 85, 1, 1, 1);
INSERT INTO `oa_role_node` VALUES (1, 100, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (1, 101, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (1, 106, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (1, 104, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (1, 105, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (1, 107, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (1, 177, 1, 1, 1);
INSERT INTO `oa_role_node` VALUES (1, 102, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (1, 143, 1, 1, 1);
INSERT INTO `oa_role_node` VALUES (1, 108, 1, 1, 1);
INSERT INTO `oa_role_node` VALUES (1, 124, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (1, 87, 1, 1, 1);
INSERT INTO `oa_role_node` VALUES (1, 144, 1, 1, 1);
INSERT INTO `oa_role_node` VALUES (1, 149, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (1, 150, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (1, 147, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (1, 148, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (1, 234, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (1, 185, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (1, 184, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (1, 146, 1, 1, 1);
INSERT INTO `oa_role_node` VALUES (1, 221, 1, 1, 1);
INSERT INTO `oa_role_node` VALUES (1, 222, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (1, 88, 1, 1, 1);
INSERT INTO `oa_role_node` VALUES (1, 126, 1, 1, 1);
INSERT INTO `oa_role_node` VALUES (1, 219, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (1, 220, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (1, 189, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (1, 226, 1, 1, 1);
INSERT INTO `oa_role_node` VALUES (1, 227, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (1, 228, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (1, 229, 1, 1, 1);
INSERT INTO `oa_role_node` VALUES (1, 194, 1, 1, 1);
INSERT INTO `oa_role_node` VALUES (1, 205, 1, 1, 1);
INSERT INTO `oa_role_node` VALUES (1, 206, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (8, 85, 1, 1, 1);
INSERT INTO `oa_role_node` VALUES (8, 100, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (8, 101, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (8, 106, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (8, 104, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (8, 105, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (8, 107, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (8, 177, 1, 1, 1);
INSERT INTO `oa_role_node` VALUES (8, 102, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (8, 143, 1, 1, 1);
INSERT INTO `oa_role_node` VALUES (8, 108, 1, 1, 1);
INSERT INTO `oa_role_node` VALUES (8, 124, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (8, 88, 1, 1, 1);
INSERT INTO `oa_role_node` VALUES (8, 126, 1, 1, 1);
INSERT INTO `oa_role_node` VALUES (8, 219, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (8, 220, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (8, 189, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (8, 221, 1, 1, 1);
INSERT INTO `oa_role_node` VALUES (8, 222, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (8, 226, 1, 1, 1);
INSERT INTO `oa_role_node` VALUES (8, 227, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (8, 228, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (8, 229, 1, 1, 1);
INSERT INTO `oa_role_node` VALUES (8, 194, 1, 1, 1);
INSERT INTO `oa_role_node` VALUES (7, 85, 1, 1, 1);
INSERT INTO `oa_role_node` VALUES (7, 100, 1, 1, 1);
INSERT INTO `oa_role_node` VALUES (7, 101, 1, 1, 1);
INSERT INTO `oa_role_node` VALUES (7, 106, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (7, 104, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (7, 105, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (7, 107, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (7, 177, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (9, 217, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (9, 84, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (9, 110, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (9, 115, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (9, 123, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (9, 153, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (9, 116, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (9, 113, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (9, 121, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (9, 114, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (1, 239, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (1, 240, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (1, 241, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (1, 242, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (1, 243, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (1, 244, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (1, 245, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (1, 217, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (1, 216, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (1, 224, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (1, 214, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (1, 157, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (1, 169, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (1, 156, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (1, 158, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (1, 198, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (1, 191, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (1, 193, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (1, 192, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (1, 125, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (1, 91, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (1, 152, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (1, 190, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (1, 84, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (1, 110, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (1, 238, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (1, 115, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (1, 123, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (1, 153, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (1, 116, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (1, 112, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (1, 118, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (1, 119, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (1, 120, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (1, 113, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (1, 121, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (1, 114, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (8, 239, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (8, 240, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (8, 243, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (8, 217, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (8, 216, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (8, 224, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (8, 214, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (8, 157, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (8, 169, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (8, 156, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (8, 158, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (8, 198, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (8, 191, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (8, 193, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (8, 192, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (8, 125, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (8, 91, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (8, 152, NULL, NULL, NULL);
INSERT INTO `oa_role_node` VALUES (8, 190, NULL, NULL, NULL);

-- ----------------------------
-- Table structure for oa_role_user
-- ----------------------------
DROP TABLE IF EXISTS `oa_role_user`;
CREATE TABLE `oa_role_user`  (
  `role_id` mediumint(9) UNSIGNED NULL DEFAULT NULL,
  `user_id` char(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  INDEX `group_id`(`role_id`) USING BTREE,
  INDEX `user_id`(`user_id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Compact;

-- ----------------------------
-- Records of oa_role_user
-- ----------------------------
INSERT INTO `oa_role_user` VALUES (4, '27');
INSERT INTO `oa_role_user` VALUES (4, '26');
INSERT INTO `oa_role_user` VALUES (5, '31');
INSERT INTO `oa_role_user` VALUES (3, '22');
INSERT INTO `oa_role_user` VALUES (1, '4');
INSERT INTO `oa_role_user` VALUES (1, '3');
INSERT INTO `oa_role_user` VALUES (1, '35');
INSERT INTO `oa_role_user` VALUES (1, '36');
INSERT INTO `oa_role_user` VALUES (1, '54');
INSERT INTO `oa_role_user` VALUES (2, '3');
INSERT INTO `oa_role_user` VALUES (1, '53');
INSERT INTO `oa_role_user` VALUES (7, '36');
INSERT INTO `oa_role_user` VALUES (1, '63');
INSERT INTO `oa_role_user` VALUES (1, '64');
INSERT INTO `oa_role_user` VALUES (2, '41');
INSERT INTO `oa_role_user` VALUES (2, '68');
INSERT INTO `oa_role_user` VALUES (1, '44');
INSERT INTO `oa_role_user` VALUES (2, '44');
INSERT INTO `oa_role_user` VALUES (7, '44');
INSERT INTO `oa_role_user` VALUES (1, '67');
INSERT INTO `oa_role_user` VALUES (2, '67');
INSERT INTO `oa_role_user` VALUES (7, '67');
INSERT INTO `oa_role_user` VALUES (1, '48');
INSERT INTO `oa_role_user` VALUES (2, '48');
INSERT INTO `oa_role_user` VALUES (7, '48');
INSERT INTO `oa_role_user` VALUES (1, '42');
INSERT INTO `oa_role_user` VALUES (2, '42');
INSERT INTO `oa_role_user` VALUES (7, '42');
INSERT INTO `oa_role_user` VALUES (1, '43');
INSERT INTO `oa_role_user` VALUES (2, '43');
INSERT INTO `oa_role_user` VALUES (7, '43');
INSERT INTO `oa_role_user` VALUES (1, '49');
INSERT INTO `oa_role_user` VALUES (2, '49');
INSERT INTO `oa_role_user` VALUES (7, '49');
INSERT INTO `oa_role_user` VALUES (1, '50');
INSERT INTO `oa_role_user` VALUES (2, '50');
INSERT INTO `oa_role_user` VALUES (7, '50');
INSERT INTO `oa_role_user` VALUES (1, '51');
INSERT INTO `oa_role_user` VALUES (2, '51');
INSERT INTO `oa_role_user` VALUES (7, '51');
INSERT INTO `oa_role_user` VALUES (1, '52');
INSERT INTO `oa_role_user` VALUES (2, '52');
INSERT INTO `oa_role_user` VALUES (7, '52');
INSERT INTO `oa_role_user` VALUES (1, '55');
INSERT INTO `oa_role_user` VALUES (2, '55');
INSERT INTO `oa_role_user` VALUES (7, '55');
INSERT INTO `oa_role_user` VALUES (1, '57');
INSERT INTO `oa_role_user` VALUES (2, '57');
INSERT INTO `oa_role_user` VALUES (7, '57');
INSERT INTO `oa_role_user` VALUES (1, '58');
INSERT INTO `oa_role_user` VALUES (2, '58');
INSERT INTO `oa_role_user` VALUES (7, '58');
INSERT INTO `oa_role_user` VALUES (1, '59');
INSERT INTO `oa_role_user` VALUES (2, '59');
INSERT INTO `oa_role_user` VALUES (7, '59');
INSERT INTO `oa_role_user` VALUES (1, '60');
INSERT INTO `oa_role_user` VALUES (2, '60');
INSERT INTO `oa_role_user` VALUES (7, '60');
INSERT INTO `oa_role_user` VALUES (1, '61');
INSERT INTO `oa_role_user` VALUES (2, '61');
INSERT INTO `oa_role_user` VALUES (7, '61');
INSERT INTO `oa_role_user` VALUES (1, '56');
INSERT INTO `oa_role_user` VALUES (2, '56');
INSERT INTO `oa_role_user` VALUES (7, '56');
INSERT INTO `oa_role_user` VALUES (1, '62');
INSERT INTO `oa_role_user` VALUES (2, '62');
INSERT INTO `oa_role_user` VALUES (7, '62');
INSERT INTO `oa_role_user` VALUES (1, '65');
INSERT INTO `oa_role_user` VALUES (2, '65');
INSERT INTO `oa_role_user` VALUES (7, '65');
INSERT INTO `oa_role_user` VALUES (1, '66');
INSERT INTO `oa_role_user` VALUES (2, '66');
INSERT INTO `oa_role_user` VALUES (7, '66');
INSERT INTO `oa_role_user` VALUES (2, '83');
INSERT INTO `oa_role_user` VALUES (2, '84');
INSERT INTO `oa_role_user` VALUES (2, '87');
INSERT INTO `oa_role_user` VALUES (2, '88');
INSERT INTO `oa_role_user` VALUES (2, '89');
INSERT INTO `oa_role_user` VALUES (2, '91');
INSERT INTO `oa_role_user` VALUES (2, '92');
INSERT INTO `oa_role_user` VALUES (2, '93');
INSERT INTO `oa_role_user` VALUES (2, '95');
INSERT INTO `oa_role_user` VALUES (2, '96');
INSERT INTO `oa_role_user` VALUES (2, '97');
INSERT INTO `oa_role_user` VALUES (2, '98');
INSERT INTO `oa_role_user` VALUES (1, '90');
INSERT INTO `oa_role_user` VALUES (2, '90');
INSERT INTO `oa_role_user` VALUES (7, '90');
INSERT INTO `oa_role_user` VALUES (8, '90');
INSERT INTO `oa_role_user` VALUES (9, '90');
INSERT INTO `oa_role_user` VALUES (10, '90');
INSERT INTO `oa_role_user` VALUES (11, '90');
INSERT INTO `oa_role_user` VALUES (1, '94');
INSERT INTO `oa_role_user` VALUES (2, '94');
INSERT INTO `oa_role_user` VALUES (7, '94');
INSERT INTO `oa_role_user` VALUES (8, '94');
INSERT INTO `oa_role_user` VALUES (9, '94');
INSERT INTO `oa_role_user` VALUES (10, '94');
INSERT INTO `oa_role_user` VALUES (11, '94');
INSERT INTO `oa_role_user` VALUES (8, '2');
INSERT INTO `oa_role_user` VALUES (1, '10');
INSERT INTO `oa_role_user` VALUES (9, '10');
INSERT INTO `oa_role_user` VALUES (1, '1');
INSERT INTO `oa_role_user` VALUES (8, '11');

-- ----------------------------
-- Table structure for oa_schedule
-- ----------------------------
DROP TABLE IF EXISTS `oa_schedule`;
CREATE TABLE `oa_schedule`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '',
  `content` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `location` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '',
  `priority` int(11) NULL DEFAULT NULL,
  `actor` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '',
  `user_id` int(11) NULL DEFAULT 0,
  `start_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `end_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `add_file` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '',
  `is_del` tinyint(3) NULL DEFAULT 0,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 9 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Compact;


-- ----------------------------
-- Table structure for oa_sign
-- ----------------------------
DROP TABLE IF EXISTS `oa_sign`;
CREATE TABLE `oa_sign`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `dept_id` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `dept_name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `user_id` int(11) NULL DEFAULT NULL,
  `user_name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `position_name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `state` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `create_time` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `wei` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `jing` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `address` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `status` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `remark` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `is_del` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '0',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 32 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;


-- ----------------------------
-- Table structure for oa_supplier
-- ----------------------------
DROP TABLE IF EXISTS `oa_supplier`;
CREATE TABLE `oa_supplier`  (
  `id` int(6) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `letter` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '',
  `short` varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '',
  `account` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '',
  `tax_no` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '',
  `payment` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `contact` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `office_tel` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `mobile_tel` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '',
  `email` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '',
  `im` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '',
  `address` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '',
  `user_id` int(11) NOT NULL,
  `is_del` tinyint(3) NOT NULL DEFAULT 0,
  `remark` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `fax` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `user_name` varchar(21) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Compact;

-- ----------------------------
-- Table structure for oa_system_config
-- ----------------------------
DROP TABLE IF EXISTS `oa_system_config`;
CREATE TABLE `oa_system_config`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `val` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `is_del` tinyint(3) NOT NULL DEFAULT 0,
  `sort` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `pid` int(11) NULL DEFAULT 0,
  `data_type` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `id`(`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 51 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Compact;

-- ----------------------------
-- Records of oa_system_config
-- ----------------------------
INSERT INTO `oa_system_config` VALUES (39, 'system_name', '', '良精OA办公系统', 0, NULL, 0, 'system');
INSERT INTO `oa_system_config` VALUES (40, 'system_license', '', '11', 0, NULL, 0, 'system');
INSERT INTO `oa_system_config` VALUES (41, 'upload_file_ext', '', '1', 0, NULL, 0, 'system');
INSERT INTO `oa_system_config` VALUES (42, 'login_verify_code', '', '', 0, NULL, 0, 'system');
INSERT INTO `oa_system_config` VALUES (43, 'signin_start_time', '', '09:00', 0, NULL, 0, 'sign');
INSERT INTO `oa_system_config` VALUES (45, 'signback_start_time', '', '18:00', 0, NULL, 0, 'sign');
INSERT INTO `oa_system_config` VALUES (47, 'address', '', '北京市,北京市,丰台区', 0, NULL, 0, 'sign');
INSERT INTO `oa_system_config` VALUES (48, 'jing', '', '116.305187', 0, NULL, 0, 'sign');
INSERT INTO `oa_system_config` VALUES (49, 'distance', '', '200', 0, NULL, 0, 'sign');
INSERT INTO `oa_system_config` VALUES (50, 'wei', '', '39.835478', 0, NULL, 0, 'sign');

-- ----------------------------
-- Table structure for oa_system_folder
-- ----------------------------
DROP TABLE IF EXISTS `oa_system_folder`;
CREATE TABLE `oa_system_folder`  (
  `id` int(3) NOT NULL AUTO_INCREMENT,
  `pid` int(11) NOT NULL,
  `controller` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `admin` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `write` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `read` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `sort` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `is_del` tinyint(3) NOT NULL DEFAULT 0,
  `remark` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 2 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Compact;

-- ----------------------------
-- Records of oa_system_folder
-- ----------------------------
INSERT INTO `oa_system_folder` VALUES (1, 0, 'Doc', '演示员', '王瑞峰/助理|王瑞峰;', '王瑞峰/助理|王瑞峰;', '王瑞峰/助理|王瑞峰;', '1', 0, '');

-- ----------------------------
-- Table structure for oa_system_log
-- ----------------------------
DROP TABLE IF EXISTS `oa_system_log`;
CREATE TABLE `oa_system_log`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` tinyint(3) NULL DEFAULT NULL,
  `time` int(11) NULL DEFAULT NULL,
  `data` float NULL DEFAULT NULL,
  `text` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 53 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Compact;

-- ----------------------------
-- Records of oa_system_log
-- ----------------------------
INSERT INTO `oa_system_log` VALUES (41, 1, 1451050584, 0, NULL);
INSERT INTO `oa_system_log` VALUES (42, 2, 1451050584, 0, NULL);
INSERT INTO `oa_system_log` VALUES (43, 1, 1542696885, 0, NULL);
INSERT INTO `oa_system_log` VALUES (44, 2, 1542696885, 0, NULL);
INSERT INTO `oa_system_log` VALUES (45, 1, 1543212514, 0, NULL);
INSERT INTO `oa_system_log` VALUES (46, 2, 1543212514, 0, NULL);
INSERT INTO `oa_system_log` VALUES (47, 1, 1544436029, 0, NULL);
INSERT INTO `oa_system_log` VALUES (48, 2, 1544436029, 0, NULL);
INSERT INTO `oa_system_log` VALUES (49, 1, 1544575754, 1, NULL);
INSERT INTO `oa_system_log` VALUES (50, 2, 1544575754, 0.011549, NULL);
INSERT INTO `oa_system_log` VALUES (51, 1, 1544663098, 1, NULL);
INSERT INTO `oa_system_log` VALUES (52, 2, 1544663098, 0.011549, NULL);

-- ----------------------------
-- Table structure for oa_task
-- ----------------------------
DROP TABLE IF EXISTS `oa_task`;
CREATE TABLE `oa_task`  (
  `id` int(8) UNSIGNED NOT NULL AUTO_INCREMENT,
  `task_no` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `pid` int(11) NULL DEFAULT NULL,
  `name` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '标题',
  `content` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '内容',
  `executor` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `add_file` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `expected_time` datetime NULL DEFAULT NULL,
  `user_id` int(11) UNSIGNED NULL DEFAULT 0,
  `user_name` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `dept_id` int(11) NULL DEFAULT NULL,
  `dept_name` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `create_time` int(11) NULL DEFAULT NULL,
  `update_time` int(11) NULL DEFAULT NULL,
  `update_user_id` int(11) NULL DEFAULT NULL,
  `update_user_name` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `status` tinyint(3) NULL DEFAULT 0,
  `is_del` tinyint(3) NULL DEFAULT NULL,
  `type` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 12 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Compact;


-- ----------------------------
-- Table structure for oa_task_log
-- ----------------------------
DROP TABLE IF EXISTS `oa_task_log`;
CREATE TABLE `oa_task_log`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `task_id` int(11) NULL DEFAULT NULL,
  `type` tinyint(3) NULL DEFAULT NULL,
  `assigner` int(11) NULL DEFAULT NULL COMMENT '分配任务的人',
  `executor` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '执行人',
  `executor_name` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `status` tinyint(3) NULL DEFAULT 0,
  `plan_time` datetime NULL DEFAULT NULL,
  `transactor_name` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `transactor` int(11) NULL DEFAULT NULL COMMENT '由谁处理的',
  `finish_rate` tinyint(3) NULL DEFAULT NULL,
  `finish_time` datetime NULL DEFAULT NULL,
  `feed_back` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `add_file` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 7 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Compact;


-- ----------------------------
-- Table structure for oa_todo
-- ----------------------------
DROP TABLE IF EXISTS `oa_todo`;
CREATE TABLE `oa_todo`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `content` text CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `user_id` int(11) NOT NULL,
  `end_date` varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `priority` int(11) NOT NULL,
  `add_file` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `status` tinyint(3) NOT NULL DEFAULT 0,
  `sort` int(11) NULL DEFAULT NULL,
  `create_time` varchar(0) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 4 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Compact;



-- ----------------------------
-- Table structure for oa_user_folder
-- ----------------------------
DROP TABLE IF EXISTS `oa_user_folder`;
CREATE TABLE `oa_user_folder`  (
  `id` int(3) NOT NULL AUTO_INCREMENT,
  `pid` int(11) NOT NULL,
  `controller` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `user_id` int(11) NOT NULL,
  `name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `sort` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `is_del` tinyint(3) NOT NULL DEFAULT 0,
  `remark` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Compact;

-- ----------------------------
-- Table structure for oa_user_tag
-- ----------------------------
DROP TABLE IF EXISTS `oa_user_tag`;
CREATE TABLE `oa_user_tag`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pid` int(11) NOT NULL DEFAULT 0,
  `controller` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `user_id` int(11) NOT NULL,
  `name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `sort` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `remark` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `is_del` tinyint(3) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 5 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Compact;


-- ----------------------------
-- Table structure for oa_user_tag_data
-- ----------------------------
DROP TABLE IF EXISTS `oa_user_tag_data`;
CREATE TABLE `oa_user_tag_data`  (
  `row_id` int(11) NOT NULL DEFAULT 0,
  `tag_id` int(11) NOT NULL DEFAULT 0,
  `controller` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  INDEX `row_id`(`row_id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Compact;


-- ----------------------------
-- Table structure for oa_work_log
-- ----------------------------
DROP TABLE IF EXISTS `oa_work_log`;
CREATE TABLE `oa_work_log`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL DEFAULT 0,
  `user_name` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `dept_id` int(11) NULL DEFAULT NULL,
  `dept_name` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `create_time` int(11) NULL DEFAULT NULL,
  `content` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `plan` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `start_date` date NULL DEFAULT NULL,
  `end_date` date NULL DEFAULT NULL,
  `is_del` tinyint(3) NOT NULL DEFAULT 0,
  `add_file` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `status` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '0',
  `auditor` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `update_time` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `shen_msg` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 6 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Compact;


SET FOREIGN_KEY_CHECKS = 1;